#include <algorithm>
#include <bits/stdc++.h>
 
using namespace std;
 
typedef long long ll;
typedef long double ld;
 
typedef vector<int> vi;
typedef vector<ll> vll;
 
typedef vector<vi> vvi;
typedef vector<vll> vvll;
 
typedef pair<int, int> pii;
typedef pair<ll, ll> pll;
 
typedef vector<pii> vpii;
typedef vector<pll> vpll;
 
typedef vector<vpii> vvpii;
typedef vector<vpll> vvpll;
 
#define pb push_back
#define mp make_pair
#define all(x) (x).begin(), (x).end()
#define rall(x) (x).rbegin(), (x).rend()
#define sz(x) (int)(x).size()
#define fi first
#define se second
 
template<class T> bool ckmin(T &a, const T &b) {return a > b ? a = b, 1 : 0;}
template<class T> bool ckmax(T &a, const T &b) {return a < b ? a = b, 1 : 0;}
 
namespace debug {
    void __print(int x) {cerr << x;}
    void __print(long long x) {cerr << x;}
    void __print(double x) {cerr << x;}
    void __print(long double x) {cerr << x;}
    void __print(char x) {cerr << '\'' << x << '\'';}
    void __print(const string &x) {cerr << '\"' << x << '\"';}
    void __print(const char *x) {cerr << '\"' << x << '\"';}
    void __print(bool x) {cerr << (x ? "true" : "false");}
 
    template<typename T, typename V>
    void __print(const pair<T, V> &x) {cerr << '{'; __print(x.first); cerr << ','; __print(x.second); cerr << '}';}
    template<typename T>
    void __print(const T &x) {int f = 0; cerr << '{'; for(auto z : x) cerr << (f++ ? "," : ""), __print(z); cerr << "}";}
    void _print() {cerr << "]\n";}
    template <typename T, typename... V>
    void _print(T t, V... v) {__print(t); if(sizeof...(v)) cerr << ", "; _print(v...);}
 
#ifdef DEBUG
#define dbg(x...) cerr << "\e[91m" << "LINE(" << __LINE__ << ") -> " << "[" << #x << "] = ["; _print(x); cerr << "\033[0m";
#else
#define dbg(x...)
#endif
}
 
using namespace debug;
 
const char nl = '\n';
 
mt19937 rng(chrono::high_resolution_clock::now().time_since_epoch().count());

const int mxN = 2e5 + 12;

vi adj[mxN];

ll dodji[mxN];
ll nz[mxN];
ll suma[mxN];

void dfs(int s, int p = -1) {
    suma[s] = nz[s];
    dodji[s] = 0;

    for(auto e : adj[s]) {
        if(e == p) continue;
        dfs(e, s);
    }

    for(auto e : adj[s]) {
        if(e == p) continue;
        suma[s] += suma[e];
        dodji[s] += suma[e];
        dodji[s] += dodji[e];
    }
}

ll ans[mxN];

void dfs2(int s, int p = -1) {
    ans[s] = dodji[s];

    for(auto e : adj[s]) {
        if(e == p) continue;
        dodji[s] -= dodji[e];
        dodji[s] -= suma[e];
        suma[s] -= suma[e];
        suma[e] += suma[s];
        dodji[e] += suma[s];
        dodji[e] += dodji[s];
        dfs2(e, s);
        dodji[e] -= dodji[s];
        dodji[e] -= suma[s];
        suma[e] -= suma[s];
        suma[s] += suma[e];
        dodji[s] += suma[e];
        dodji[s] += dodji[e];
    }
}
 
void solve() {
    int n;
    cin >> n;

    for(int i = 1; i < n; ++i) {
        int u, v;
        cin >> u >> v;
        --u, --v;
        adj[u].pb(v);
        adj[v].pb(u);
    }

    for (int i = 0; i < n; ++i) {
        cin >> nz[i];
    }

    int q;
    cin >> q;

    dfs(0);
    dfs2(0);
    cout << (min_element(ans, ans + n) - ans + 1) << nl;

    for(int iter = 0; iter < q; ++iter) {
        ll x;
        int k;
        cin >> x >> k;
        --k;
        nz[k] += x;
        dfs(0);
        dfs2(0);
        cout << (min_element(ans, ans + n) - ans + 1) << nl;
    }
}
 
int main() {
    ios::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);
 
    int testCases = 1;
    // cin >> testCases;
    while(testCases--)
        solve();
}